<?php

add_filter('wpcf7_validate_textarea', 'wfs_validation_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'wfs_validation_filter', 20, 2);
add_filter('wpcf7_validate_text', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate_text*', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate_email', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate_email*', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate_tel', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate_tel*', 'wfs_validation_filter', 10, 2);
add_filter('wpcf7_validate', 'wfs_validation_form', 90, 2);

global $is_spam_detected;

$is_spam_detected = null;

/**
 * @param WPCF7_Validation $result
 * @param $tag
 * @return mixed
 */
function wfs_validation_filter($result, $tag)
{
    global $is_spam_detected;

    $was_valid = $result->is_valid();

    if (is_null($is_spam_detected)) {
        $is_spam_detected = false;
    }

    $wfs_admin = new WakaFormsSecurityAdmin();

    $waka_forms_security = $wfs_admin->get_options();

    $tags = array_key_exists('tags', $waka_forms_security) ? $waka_forms_security['tags'] : ['your-message'];

    $content = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

    if (in_array($tag->name, $tags)) {


        if (!empty($waka_forms_security['key_list'])) {
            $error = false;
            $arrW = [];
            foreach ($waka_forms_security['key_list'] as $word) {
                if (preg_match("#\b$word\b#si", $content)) {
                    $arrW[] = $word;
                    $error = true;
                }
            }

            if ($error) {

                $result->invalidate($tag, sprintf(
                        _n(
                            'Vous ne pouvez pas utiliser le mot suivant : %s ',
                            'Vous ne pouvez pas utiliser les mots suivants : %s',
                            count($arrW),
                            'waka-forms-security'),
                        implode(', ', $arrW)
                    )
                );
            }
        }

        /* if (preg_match('#https?://#s', $content)) {
            $result->invalidate($tag, __('Merci de ne pas saisir de lien dans votre message.', 'waka-forms-security'));
        } */
    }


    if ($tag->name == 'your-lastname') {

        if(isset($_POST['your-firstname']) && $_POST['your-firstname'] == $content){
            $result->invalidate($tag, __("Anti spam : vous ne pouvez pas avoir un prénom et un nom identiques pour valider ce forumlaire.", "waka-forms-security"));
        }

        if(isset($_POST['your-firstname']) && $_POST['your-firstname'] == 'James' && $content == 'Smith'){
            $result->invalidate($tag, __("Anti spam : Ce nom n'est pas autorisé.", "waka-forms-security"));
        }

    }
    if ($tag->name == 'your-phone') {

        // Gestion spam
        if (strlen($content) == 11 && substr($content, 0, 1) == '8') {

            // error_log('=== debug spam ' . date('d/m/Y H:i:s') . "\n", 3, ABSPATH . '/wp-content/debug.log');

            $result->invalidate($tag, __("Votre numéro de téléphone est invalide.", "waka-forms-security"));
        }

        if(substr($content, 0, 2) == '+1'){
            $result->invalidate($tag, __("Votre numéro de téléphone est invalide.", "waka-forms-security"));
        }

        if($content == '1') {
            $result->invalidate($tag, __("Numéro de téléphone invalide.", "waka-forms-security"));

        }
    }

    if (in_array(mb_strtolower($tag->name), ['your-job', 'your-profile-autre', 'your-firstname', 'your-lastname', 'your-name', 'name', 'prenom', 'nom'])) {

        // 6 caractères en minuscules avec au moins un chiffre
        if(preg_match('/^(?=.*\d)[a-z\d]{6}$/', $content) === 1) {
            $result->invalidate($tag, __("Contrôle anti-spam : cette valeur n'est pas correcte. Veuillez modifier votre saisie.", "waka-forms-security"));
        }

    }
    if (in_array(mb_strtolower($tag->name), ['your-job', 'your-message', 'your-profile-autre', 'your-firstname', 'your-lastname', 'your-name', 'name', 'child-firstname', 'child-lastname', 'parent-firstname', 'parent-lastname', 'prenom', 'nom'])) {

        // Gestion spam : enlève toutes les chaînes de caractères alphabétiques, sans espace, qui ont au moins 3 majuscules et d'au moins 8 caractères
        // Et que ce n'est pas juste un mot composé de majuscule..
        if (preg_match("#^(?=(.*[A-Z]){2,})[A-Za-z]{8,}$#", $content) && mb_strtoupper($content) != $content) {
            $result->invalidate($tag, __("Contrôle anti-spam : la valeur n'est pas correcte. Écrivez en minuscules.", "waka-forms-security"));
        }


        // Conditions spécifiques : si c'est juste en minuscules, 10 caractères alphabétiques au moins et qu'il y a au + 2 voyelles = c'est louche.
        if ( $content === strtolower($content) &&
            ctype_alpha($content) &&
            strlen($content) >= 10 &&
            preg_match_all('/[aeiou]/i', $content) <= 2) {
            $result->invalidate($tag, __("Contrôle anti-spam : Cette valeur semble suspecte. Vérifiez votre saisie ou mettez une majuscule.", "waka-forms-security"));
        }

        if (preg_match('/[\p{Cyrillic}]/u', $content) === 1) {
            $result->invalidate($tag, __("Contrôle anti-spam : Vous ne pouvez pas écrire en Cyrillique.", "waka-forms-security"));
        }

        if(preg_match('/[\x{1F600}-\x{1F64F}\x{1F300}-\x{1F5FF}\x{1F680}-\x{1F6FF}\x{1F700}-\x{1F77F}\x{1F780}-\x{1F7FF}\x{1F800}-\x{1F8FF}\x{1F900}-\x{1F9FF}\x{1FA00}-\x{1FAFF}\x{2600}-\x{26FF}\x{2700}-\x{27BF}]/u', $content) === 1) {
            $result->invalidate($tag, __("Contrôle anti-spam : Vous ne pouvez pas écrire d'emojis.", "waka-forms-security"));
        }

    }

    if ('email' == $tag->basetype) {

        $email = isset($_POST[$tag->raw_name]) ? trim($_POST[$tag->raw_name]) : '';

        $waka_forms_security = $wfs_admin->get_options();

        if (!empty($waka_forms_security['domain_list'])) {

            $explode = explode('.', $email);
            $extension = end($explode);

            $explode = explode('@', $email);
            $domain = $explode[1];

            if (in_array($domain, $waka_forms_security['domain_list'])) {
                $result->invalidate($tag, __('Ce domaine est interdit.', 'waka-forms-security'));
            }

        }
    }

    if ($was_valid && !$result->is_valid()) {
        $is_spam_detected = true;

    }
    return $result;
}


function wfs_validation_form($result, $tags)
{
    global $is_spam_detected;

    $wfs_admin = new WakaFormsSecurityAdmin();

    $waka_forms_security = $wfs_admin->get_options();

    if (array_key_exists('clock', $_REQUEST) && !empty($_REQUEST['clock'])) {

        $diff = time() - $_REQUEST['clock'];

        if (!empty($waka_forms_security['debug'])) {
            $logger = new WakaFormsSecurityLogger();
            $logger->writeDate('Temps écoulé : ' . $diff . 's');
            $logger->write(serialize($_REQUEST));
        }

        if ($diff < 3) {
            $result->invalidate('clock', __("Suspicion de spam", "waka-forms-security"));
            $is_spam_detected = true;

            add_filter('wpcf7_display_message', function ($message, $status) {
                return __("Système anti-spam : votre temps de réponse est trop court. Veuillez réessayer dans quelques secondes.", 'waka-forms-security');
            }, 20, 2);
        } elseif ($diff > 100000) {
            $result->invalidate('clock', __("Suspicion de spam", "waka-forms-security"));
            $is_spam_detected = true;

            add_filter('wpcf7_display_message', function ($message, $status) {
                return __("Système anti-spam : votre temps de réponse est trop long. Veuillez actualiser la page et réessayer.", 'waka-forms-security');
            }, 20, 2);

        }
    }


    if ($is_spam_detected) {
        wfs_log_spam($_POST);
    }

    return $result;
}

// Ajout d'un tag "clock" qui permet de mesurer le temps de soumission d'un formulaire.
add_action( 'wpcf7_init', 'custom_add_form_tag_clock' );
function custom_add_form_tag_clock() {
    wpcf7_add_form_tag( 'clock', 'custom_clock_form_tag_handler' ); // "clock" is the type of the form-tag
}

function custom_clock_form_tag_handler( $tag ) {
    return time();
}
function wfs_log_spam($spam_data)
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'waka_spam_logs';

    // Vérifier si la table existe avant d'insérer
    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name;

    if (!$table_exists) {
        (new WakaFormsSecurityAdmin())->create_spam_table();
    }

    $wpdb->insert(
        $table_name,
        [
            'form_id'  => (int) $spam_data['_wpcf7'],
            'created_at'  => current_time('mysql'),
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'content'     => json_encode($spam_data, JSON_UNESCAPED_UNICODE)
        ],
        ['%d', '%s', '%s', '%s']
    );
    var_dump('OK4);');
}
