<?php

class WakaFormsSecurityLogger
{
    private $file;

    public function __construct($filename = "", $dir = null)
    {
        $dir = empty($dir) ? wp_upload_dir()['basedir'] . DIRECTORY_SEPARATOR . '..' : $dir;
        $filename = empty($filename) ? 'log.txt' : $filename;
        $this->file = fopen($dir . DIRECTORY_SEPARATOR . $filename, 'a+');
    }

    public function writeDate($str = "")
    {
        $this->writeLine(date('Y-m-d H:i:s') . ' - ' . $str );
    }

    public function writeError($msg)
    {
        $this->writeLine('[E] ' . $msg);
    }

    public function writeLine($text = "")
    {
        $text = !empty($text) ? ' ' . $text . ' ' : $text;
        $this->write('-----' . $text . '-----');
    }

    public function write($msg)
    {
        if(is_array($msg) || is_object($msg))
            fwrite($this->file, print_r($msg, true));
        else
            fwrite($this->file, $msg);

        return fwrite($this->file, "\n");
    }

    public function __destruct()
    {
        fclose($this->file);
    }
}