<?php

class WakaFormsSecurityAdmin
{
    private $plugin_name;

    public function __construct($plugin_name = 'waka-forms-security')
    {
        $this->plugin_name = $plugin_name;
    }

    public function init()
    {
        add_action('admin_menu', [$this, 'admin_page']);
        add_action('plugin_action_links_' . WAKA_FORMS_SECURITY_BASENAME, [$this, 'add_settings_link']);
        add_action('admin_post_waka_forms_security_admin', [$this, 'admin_page_submit']);
        register_activation_hook(WAKA_FORMS_SECURITY_FILE, [$this, 'activate_plugin']);
        register_deactivation_hook(WAKA_FORMS_SECURITY_FILE, [$this, 'deactivate_plugin']);

        add_action('wpcf7_admin_init', [$this, 'wpcf7_add_tag_generator_antispam_clock'], 95, 0);


        // Ajout d'un tag "clock" qui permet de mesurer le temps de soumission d'un formulaire.
        add_action('wpcf7_init', [$this, 'custom_add_form_tag_clock']);

        // Programmer une tâche de nettoyage quotidienne
        if (!wp_next_scheduled('wfs_clean_old_spam')) {
            wp_schedule_event(time(), 'daily', 'wfs_clean_old_spam');
        }

        add_action('wfs_clean_old_spam', [$this, 'wfs_clean_old_spam']);
    }

    public function admin_page()
    {
        add_submenu_page(
            'wpcf7',
            'Sécurité des formulaires',
            'Sécurité des formulaires',
            'manage_options',
            $this->plugin_name,
            [$this, 'render_admin_page']
        );
    }

    public function get_options()
    {
        return get_option($this->plugin_name);
    }

    public function add_settings_link($links)
    {
        $links = array_merge(array('<a href="' . admin_url('admin.php?page=' . $this->plugin_name) . '">' . __('Settings') . '</a>'), $links);
        return $links;
    }

    public function render_admin_page()
    {
        ?>
        <h1><?php _e('Sécurité des formulaires', 'waka-forms-security') ?></h1>

        <?php $options = $this->get_options();
//        echo '<pre>';
//        print_r($options);
//        echo '</pre>';
        ?>
        <form method="post" action="<?php echo admin_url('admin-post.php') ?>">

            <h2 class="title"><?php _e('Mots à interdire', 'waka-forms-security') ?></h2>
            <p>
                <label for="key_list"><?php _e('Saisissez la liste des mots à interdire.', 'waka-forms-security') ?></label><br/>
                <em><?php _e('1 par ligne', 'waka-forms-security') ?></em></p>
            <textarea name="key_list" id="key_list" cols="30" rows="10"
                      class="large-text code"><?php echo !empty($options['key_list']) ? implode("\n", (array)$options['key_list']) : '' ?></textarea>

            <h3 class="title"><?php _e('Sélectionnez les champs dans lesquels vérifier les mots à exclure', 'waka-forms-security') ?></h3>
            <div>
                <?php
                $contact_forms = $this->get_forms();
                if (!empty($contact_forms)) {
                    $arrTags = [];
                    foreach ($contact_forms as $contact_form) {
                        foreach ($this->get_tags($contact_form->ID) as $tag) {
                            if (!in_array($tag, $arrTags)) {
                                $arrTags[] = $tag;
                            }
                        }
                    }
                    foreach ($arrTags as $tag) {
                        $checked = (!empty($options['tags']) && in_array($tag, $options['tags'])) || (!isset($options['tags']) && 'your-message' == $tag);
                        ?>
                        <label><input type="checkbox"
                                      name="tags[]" <?php checked($checked) ?>
                                      value="<?= $tag ?>">[<?= $tag ?>] &nbsp; </label><?php
                    }
                }
                ?>
            </div>

            <br/>
            <hr/>

            <div>
                <h2 class="title"><?php _e('Domaines à exclure', 'waka-forms-security') ?></h2>
                <p>
                    <label for="domain_list"><?php _e('Saisissez la liste des domaines à exclure pour tous les champs de type "email" (exemple : <em>yopmail.com</em>)') ?></label>
                    <br/><em><?php _e('1 par ligne', 'waka-forms-security') ?></em></p>
                <textarea name="domain_list" id="domain_list" cols="30" rows="10"
                          class="large-text code"><?php echo !empty($options['domain_list']) ? implode("\n", (array)$options['domain_list']) : '' ?></textarea>
            </div>

            <br/>
            <hr/>

            <div>
                <h2 class="title"><?php _e('Vérification du temps de remplissage du formulaire', 'waka-forms-security') ?></h2>

                <p><?php _e('Pour ajouter une vérification sur le temps de remplissage du formulaire, insérez le champ suivant dans le code du formulaire Contact Form 7 : ', 'waka-forms-security') ?></p>
                <pre>[wfs_antispam clock]</pre>
                <p><?php _e('<em>Les formulaires remplis en moins de 3 secondes seront considérés comme du spam.</em>', 'waka-forms-security') ?></p>

            </div>


            <br/>
            <hr/>

            <div>
                <h2 class="title"><?php _e('Activer le debug', 'waka-forms-security') ?></h2>

                <?php
                $debug = array_key_exists('debug', $options) && !empty($options['debug']);
                ?>
                <p>
                    <label>
                        <input type="checkbox" name="debug" <?php checked($debug) ?> value="1">Activer le debug dans le fichier log
                    </label>
                </p>

            </div>

            <p class="submit">
                <input type="submit" id="submit" class="button button-primary"
                       value="<?php esc_attr_e('Enregistrer les modifications', 'waka-forms-security') ?>">
            </p>

            <input type="hidden" name="action" value="waka_forms_security_admin"/>
            <?php wp_nonce_field('waka_forms_security_admin') ?>
        </form>

        <?php
    }

    public function get_tags($form_id)
    {
        $contactForm = WPCF7_ContactForm::get_instance($form_id);
        $tags = $contactForm->scan_form_tags();
        $arr = [];

        /** @var WPCF7_FormTag $tag */
        foreach ($tags as $tag):
            if (in_array($tag->basetype, ['text', 'textarea', 'email'])) {
                $arr[] = $tag->name;
            }
        endforeach;

        return $arr;
    }

    public function get_forms()
    {
        return get_posts(['posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form']);
    }

    public function admin_page_submit()
    {
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'waka_forms_security_admin')) {
            wp_die('Erreur, veuillez réessayer.');
        }

        $options = [];

        if (!empty($_POST['tags'])) {
            $options['tags'] = $_POST['tags'];
        }

        if (!empty($_POST['key_list'])) {
            $options['key_list'] = array_map([$this, 'wfs_clean_and_lowercase_string'], explode("\n", $_POST['key_list']));
            $options['key_list'] = array_filter($options['key_list'], function($item){ return !empty($item); });
        }

        if (!empty($_POST['domain_list'])) {
            $options['domain_list'] = array_map([$this, 'wfs_clean_and_lowercase_string'], explode("\n", $_POST['domain_list']));
        }

        $options['debug'] = (int)!empty($_POST['debug']);

        $this->update_option($options);

        wp_redirect($_REQUEST['_wp_http_referer']);
        exit();
    }

    private function wfs_clean_and_lowercase_string($str)
    {
        return trim(mb_strtolower(stripslashes($str)));
    }

    public function activate_plugin()
    {
        $this->create_spam_table();

        $options = $this->get_options();

        // Set default values on plugin activation.
        if (empty($options)) {

            $options = ['key_list' =>
                ['pharmacie',
                    'médicaments',
                    'xanax',
                    'viagra',
                    'vicodin',
                    'online',
                    'docteur',
                    'doctor',
                    'minceur',
                    'maigrir',
                    'diet',
                    'sex',
                    'sexe',
                    'hot',
                    'porn',
                    'porno',
                    'sexy',
                    'sexe',
                    'penis',
                    'vagin',
                    'vagina',
                    'girl',
                    'girls',
                    'casino',
                    'blackjack',
                    'poker',
                    'jetons',
                    'roulette',
                    'texas',
                    'hold\'em',
                    'holdem',
                    'hold',
                    'crypto',
                    'online promotion',
                    'advertising',
                    'http',
                    'https',
                ],
                'domain_list' => [
                    'sammail.ws',
                    'vmani.com',
                    'yopmail.com',
                    'mailboxok.club',
                    'enayu.com',
                    'seo-mailer.com',
                    'tempr.email',
                    'discard.email',
                    'discardmail.com',
                    'discardmail.de',
                    'spambog.com',
                    'spambog.de',
                    'spambog.ru',
                    '0815.ru',
                    'btcmail.pw',
                    'knol-power.nl',
                    'hartbot.de',
                    'freundin.ru',
                    'smashmail.de',
                    's0ny.net',
                    'pecinan.net',
                    'budaya-tionghoa.com',
                    'lajoska.pe.hu',
                    '1mail.x24hr.com',
                    'from.onmypc.info',
                    'now.mefound.com',
                    'mowgli.jungleheart.com',
                    'yourspamgoesto.space',
                    'pecinan.org',
                    'budayationghoa.com',
                    'katergizmo.de',
                    'cr.cloudns.asia',
                    'tls.cloudns.asia',
                    'msft.cloudns.asia',
                    'b.cr.cloudns.asia',
                    'ssl.tls.cloudns.asia',
                    'sweetxxx.de',
                    'dvd.dns-cloud.net',
                    'dvd.dnsabr.com',
                    'bd.dns-cloud.net',
                    'yx.dns-cloud.net',
                    'shit.dns-cloud.net',
                    'shit.dnsabr.com',
                    'eu.dns-cloud.net',
                    'eu.dnsabr.com',
                    'asia.dnsabr.com',
                    '8.dnsabr.com',
                    'pw.8.dnsabr.com',
                    'mm.8.dnsabr.com',
                    '23.8.dnsabr.com',
                    'email-mail.pw',
                    'pw.email-mail.cf',
                    'x.dc74.ml',
                    'x.dc74.cf',
                    'mailpost.gq',
                    'pecinan.com',
                    'disposable-email.ml',
                    'pw.epac.to',
                    'brunhilde.ml',
                    'mailpost.ga',
                    'giallo.tk',
                    'giallo.cf',
                    'giallo.ml',
                    'giallo.gq',
                    'postheo.de',
                    'my.viola.gq',
                    'spam.viola.gq',
                    'tempr.email.viola.gq',
                    'email.viola.gq',
                    'sexy.camdvr.org',
                    'gay.theworkpc.com',
                    'etr610.cf',
                    'etr610.ga',
                    'etr610.gq',
                    'purple.viola.gq',
                    'disposable.ml',
                    'disposable-e.ml',
                    '09stees.online',
                    '07stees.online',
                    'laokzmaqz.tech',
                    '1000.frecciarossa.tk',
                    'hotmailproduct.com',
                    '888.dns-cloud.net',
                    'adult-work.info',
                    'maxsize.online',
                    '1-3-3-7.net',
                    'casinokun.hu',
                    'bangsat.in',
                    'happyfreshdrink.com',
                    'sundriesday.com',
                    '8estcommunity.org',
                    'blessingvegetarian.com',
                    'cologno.cf',
                    'googulliver.site',
                    'gullivervip.space',
                    'nonciclopedia.cf',
                    'firema.cf',
                ]];
            $this->update_option($options);
        }

    }

    public function create_spam_table()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'waka_spam_logs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT(20) AUTO_INCREMENT PRIMARY KEY,
        form_id BIGINT(20),
        created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
        ip_address VARCHAR(45),
        content LONGTEXT
    ) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }

    public function deactivate_plugin(){
        wp_clear_scheduled_hook('wfs_clean_old_spam');
    }

    private function update_option($options)
    {
        update_option($this->plugin_name, $options);
    }

    function custom_add_form_tag_clock()
    {
        if(function_exists('wpcf7_add_form_tag')):
            wpcf7_add_form_tag('wfs_antispam', [$this, 'custom_clock_form_tag_handler'],
                [
                        'name-attr' => true,
                        'do-not-store' => true,
                        'not-for-mail' => true,
                ]
            );
        endif;

    }

    function custom_clock_form_tag_handler($tag)
    {
        $validation_error = wpcf7_get_validation_error( $tag->name );

        $class = wpcf7_form_controls_class( $tag->type, 'wpcf7-text' );

        if ( $validation_error ) {
            $class .= ' wpcf7-not-valid';
        }

        $atts = array();

        $atts['class'] = $tag->get_class_option( $class );
        $atts['id'] = $tag->get_id_option();

        if ( $tag->has_option( 'readonly' ) ) {
            $atts['readonly'] = 'readonly';
        }

        if ( $tag->is_required() ) {
            $atts['aria-required'] = 'true';
        }

        if ( $validation_error ) {
            $atts['aria-invalid'] = 'true';
            $atts['aria-describedby'] = wpcf7_get_validation_error_reference(
                $tag->name
            );
        } else {
            $atts['aria-invalid'] = 'false';
        }

        $atts['value'] = time();
        $atts['type'] = 'hidden';
        $atts['name'] = $tag->name;

        $atts = wpcf7_format_atts( $atts );

        $html = sprintf(
            '<span class="wpcf7-form-control-wrap %1$s"><input %2$s />%3$s</span>',
            sanitize_html_class( $tag->name ), $atts, $validation_error
        );
        return $html;
    }

    function wpcf7_add_tag_generator_antispam_clock()
    {
        $tag_generator = WPCF7_TagGenerator::get_instance();
        $tag_generator->add('wfs_antispam', __('horloge anti-spam', 'waka-forms-security'),
            [$this, 'wpcf7_tag_generator_antispam_clock']);
    }

    function wpcf7_tag_generator_antispam_clock($contact_form, $args = '')
    {
        ?>
        <div class="control-box">
            <fieldset>
                <legend><?php _e('Ce tag active la fonction "anti-spam" du plugin Waka Forms Security.', 'waka-forms-security') ?></legend>
            </fieldset>
        </div>

        <div class="insert-box">
            <input type="text" name="wfs_antispam" class="tag code" readonly="readonly" onfocus="this.select()"/>

            <div class="submitbox">
                <input type="button" class="button button-primary insert-tag"
                       value="<?php echo esc_attr(__('Insert Tag', 'contact-form-7')); ?>"/>
            </div>
        </div>
        <?php
    }

    function wfs_clean_old_spam()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'waka_spam_logs';
        $wpdb->query("DELETE FROM $table_name WHERE created_at < NOW() - INTERVAL 60 DAY");
    }

}
